# Base Addon – Basis-Konfiguration (MVP)

Diese Vorlage definiert, wie Addons in Pointer aufgebaut sind. **Kopiere den Ordner** `addons/_base/` nach `addons/<deine-addon-id>/` und passe die Dateien an.

## Ordnerstruktur (MVP)

```
addons/<id>/
  manifest.json       # Pflicht. Metadaten, capabilities, tools, optionale systemPromptHint, toolDisplay
  index.js            # Pflicht. Backend: register(loader, settings), registerTool, registerIpc
  SettingsPage.jsx    # Optional. React-Settings-UI (erhält settings, onSave)
  ToolResultViews.jsx # Optional. Eigene Ergebnis-Karten im Chat (erhält expandDetails, tc)
  constants/
    tools.js          # Optional. Tool-Namen/Liste für Settings und Backend (z. B. ALL_TOOLS)
  settings/           # Optional. Subkomponenten für SettingsPage (Tabs, Panels)
  data/               # Optional. Statische JSON-Dateien oder andere Assets
```

Discord- und FiveM-Addons nutzen: `manifest.json`, `index.js`, `SettingsPage.jsx`, `ToolResultViews.jsx` und `constants/tools.js`.

## manifest.json

- **id** – Eindeutige Addon-ID (Ordnername).
- **name**, **version**, **description**, **author** – Anzeige im Marketplace.
- **capabilities** – `["settings", "tools", "ipc"]` je nach Bedarf.
- **tools** – Array von Tool-Definitionen für die KI. Jedes Tool: `name`, `description`, `parameters` (OBJECT mit `properties`, `required`). Typen in Großbuchstaben: `OBJECT`, `STRING`, `INTEGER`.
- **defaultSettings** – Alle Einstellungs-Keys und Standardwerte; werden beim Aktivieren ins Config übernommen (kein Hardcoding im Core).
- **toolDisplay** (optional) – Pro Tool: `label`, `icon`, `expandDetailLabel` für die Chat-UI.
- **systemPromptHint** (optional) – Wird an den KI-System-Prompt angehängt, wenn das Addon aktiv ist.

### Icon-Keys (toolDisplay.icon)

Feste Schlüssel; unbekannte Keys fallen auf `fallback` zurück:

| Key        | Use case              |
|-----------|------------------------|
| `fallback`| Standard               |
| `discord` | Discord / Chat         |
| `search`  | Suche, Lookup          |
| `list`    | Listen, Channels       |
| `fivem`   | FiveM / Game-Dev       |
| `coding`  | Code / Schema          |
| `server`  | DB, Schema, Query      |
| `web`     | Web-Suche              |
| `photo`   | Bildgenerierung        |
| `bar-chart` | Charts               |
| `eye`     | Lesen / Anzeigen       |

## index.js

Export: `register(loader, settings)`.

- **loader.registerTool(toolName, handler)** – KI-Tool registrieren. `toolName` muss mit einem Eintrag in `manifest.tools` übereinstimmen. Handler: `async (args, context) => result`.
- **loader.registerIpc(channel, handler)** – IPC für Frontend↔Backend. Handler: `async (event, ...args) => result`.

`settings` kommt aus `config.addons.settings[addonId]` (mit `defaultSettings` gemerged).

## SettingsPage.jsx

Default-Export: React-Komponente mit Props `{ settings, onSave }`.

- `settings` – Aktuelle Werte (aus Config, Form = `defaultSettings`).
- `onSave(newSettings)` – Bei Änderung aufrufen; nur die geänderten Keys reichen.

CSS-Klassen wie `addon-settings`, `settings-page`, `settings-section`, `form-group` für einheitliches Aussehen.

## ToolResultViews.jsx (optional)

Default-Export: Komponente mit `{ expandDetails, tc }`.

- **expandDetails** – `{ lines: string[], raw?: any[] }` aus dem Tool-Ergebnis.
- **tc** – Tool-Call-Objekt (`name`, `args`, `result`, `addonId`, …).

Eigene Karten rendern (z. B. mit `live-tc-discord-card`), sonst Fallback z. B. `<pre><code>{lines.join('\n')}</code></pre>`. Addon bleibt **selbstständig**: keine Imports aus `src/` oder Backend-Interna.

## Regeln

- **Keine Core-Imports** – Addons importieren nicht aus `src/` oder Backend-Interna. Nur React und eigene Addon-Dateien.
- **Defaults nur im Manifest** – Alle Einstellungs-Standardwerte in `manifest.defaultSettings`; der Core merged sie automatisch.

Ausführliche Schema-Details und optionale Felder (z. B. `marketplace`, `aiModes`, Themes): siehe [addons/README.md](../README.md).
