/**
 * Base addon settings page template.
 * Default export. Props: { settings, onSave }.
 * settings = config.addons.settings[addonId] (shape from manifest.defaultSettings).
 * Call onSave(partial) when values change so config is persisted.
 */
import React, { useState, useEffect } from 'react';

export default function BaseSettingsPage({ settings, onSave }) {
  const [enabled, setEnabled] = useState(settings?.enabled ?? false);
  const [apiKey, setApiKey] = useState(settings?.apiKey ?? '');

  useEffect(() => {
    setEnabled(settings?.enabled ?? false);
    setApiKey(settings?.apiKey ?? '');
  }, [settings]);

  useEffect(() => {
    onSave?.({ enabled, apiKey });
  }, [enabled, apiKey]);

  return (
    <div className="addon-settings settings-page">
      <div className="settings-section">
        <h3>Base template settings</h3>
        <div className="settings-section-fields">
          <div className="form-group row">
            <input
              type="checkbox"
              id="base-enabled"
              checked={enabled}
              onChange={(e) => setEnabled(e.target.checked)}
            />
            <label htmlFor="base-enabled">Enable addon</label>
          </div>
          <div className="form-group">
            <label htmlFor="base-apiKey">API Key (optional)</label>
            <input
              id="base-apiKey"
              type="password"
              value={apiKey}
              onChange={(e) => setApiKey(e.target.value)}
            />
          </div>
        </div>
      </div>
    </div>
  );
}
