/**
 * Base addon – template for custom tool result views in chat.
 * Receives { expandDetails, tc }. Return your card UI or a simple fallback.
 * Self-contained: no imports from app src/.
 */
import React from 'react';

export default function BaseToolResultViews({ expandDetails, tc }) {
  const lines = (expandDetails?.lines || []).filter(Boolean);
  const raw = Array.isArray(expandDetails?.raw) ? expandDetails.raw : [];
  const name = tc?.name || '';

  // Example: custom card for example_hello result
  if (name === 'example_hello' && raw.length > 0) {
    const r = raw[0];
    return (
      <div className="live-tc-discord-card">
        <div className="live-tc-discord-card-title">{r.message || '—'}</div>
        {r.addon && <div className="live-tc-discord-card-meta">addon: {r.addon}</div>}
      </div>
    );
  }

  // Fallback: code block
  if (lines.length > 0) {
    return (
      <div className="live-tc-code-block">
        <pre className="live-tc-code"><code>{lines.join('\n')}</code></pre>
      </div>
    );
  }

  return null;
}
