/**
 * Base addon template. Copy to addons/<your-addon-id>/ and customize.
 * Tool names must match manifest.tools[].name so the AI gets the right definitions.
 *
 * @param {object} loader - Addon loader (registerTool, registerIpc); from backend addonLoader
 * @param {object} settings - Addon settings from config.addons.settings[addonId] (defaultSettings merged)
 */
function register(loader, settings) {
  // Register an AI tool – the AI can call this during chat
  loader.registerTool('example_hello', async (args, context) => {
    const name = args?.name || 'World';
    return { message: `Hello, ${name}!`, addon: 'base-template' };
  });

  // Optional: register IPC handler for frontend communication
  loader.registerIpc('addon-base-example', async (event, data) => {
    return { received: data, settings: { enabled: settings?.enabled } };
  });
}

module.exports = { register };
