# Base Theme – Configuration (MVP)

Template for creating custom themes. **Copy this folder** to `themes/<your-theme-id>/` – the **folder name is the theme id** (must match `id` in `manifest.json` and `[data-theme="<id>"]` in `theme.css`).

## Folder structure

```
themes/<id>/
  manifest.json   # Required. Metadata, titleBar, icon, optional splash
  theme.css       # Required. CSS variables under [data-theme="<id>"]
  splash.css      # Optional. Full control over splash screen; otherwise manifest.splash
```

Directories starting with `_` (e.g. `_base`) are ignored. A theme is valid only when both `manifest.json` and `theme.css` exist.

## manifest.json

- **id** – Unique id; must match the folder name.
- **name** – Display label in the theme dropdown.
- **description** – Optional; shown as hint when selected.
- **titleBar** – Required. Electron window title bar (close/minimize/maximize buttons):
  - **color** – Must match `--menu-bar-bg` in theme.css (same as menu bar)
  - **symbolColor** – Minimize/maximize/close button color
  - **height** – Optional, default 35
  - **modalColor** – Optional. When omitted, computed adaptively from color (blended with black; uses same alpha as <code>--modal-overlay-bg</code>: dark 0.6, light 0.35).
  - **modalSymbolColor** – Optional, modal symbol color (defaults to symbolColor)
- **icon** – `"dark"` | `"light"` (selects icon.ico / icon_light.ico); omit for dark.
- **splash** (optional) – Splash screen colors (when no splash.css):
  - **bg**, **accent** – Required
  - **fg**, **muted** – Optional, sensible defaults

## theme.css

Contains **all** available theme variables with short descriptions (Editor/Sidebar, Borders, Input, Lists, DataTable, Tool Call/Chat, Modal, Toast, Diagram, Fonts, Layout, Animation, Tooltip). Override only what you need; the rest inherits from `:root`. Selector: `[data-theme="<id>"]`.

Form inputs and dropdown search fields (Search Agents, Search models) use `--editor-bg` for contrast with the dropdown background. Ensure `--editor-bg` differs from `--dropdown-bg` when they would otherwise match `--input-bg`.

## Splash

1. **manifest.splash** – `bg`, `accent` (required), optional `fg`, `muted`. Splash CSS is generated from these.
2. **splash.css** – Optional. `_base/splash.css` lists all `--splash-*` variables with descriptions (background, accent, code syntax, title, copyright). Copy to `themes/<id>/splash.css` for full control.

## Addon themes

Addons can ship themes under `addons/<id>/themes/<slug>/` with the same structure (manifest.json, theme.css, optional splash.css). They are discovered only when the addon is enabled. Theme id = `addonId/slug` (e.g. `discord/dark`). See `addons/README.md`.

Full variable reference and examples: [themes/README.md](../README.md).
